/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.ui.project;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.git.ui.CloneJob;
import com.aptana.git.ui.actions.DisconnectHandler;
import com.aptana.projects.ProjectData;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.wizards.ProjectWizardContributionManager;
import com.aptana.samples.handlers.ISampleProjectHandler;
import com.aptana.samples.model.IProjectSample;
import com.aptana.samples.ui.SamplesUIPlugin;
import com.aptana.samples.ui.project.Messages;
import com.aptana.samples.ui.project.SampleNewProjectCreationPage;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewSampleProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    public static final String ID = "com.aptana.samples.ui.NewSampleProjectWizard";
    private static final String NEWPROJECT_WIZARD = "BasicNewProjectResourceWizard";
    private final IProjectSample sample;
    private SampleNewProjectCreationPage mainPage;
    private IProject newProject;
    private IConfigurationElement configElement;

    public NewSampleProjectWizard(IProjectSample sample) {
        this.sample = sample;
        this.initDialogSettings();
    }

    public void addPages() {
        ProjectWizardContributionManager projectWizardContributionManager;
        Object[] extraPages;
        super.addPages();
        this.mainPage = new SampleNewProjectCreationPage("basicNewProjectPage", this.sample.getNatures());
        this.mainPage.setTitle(Messages.NewSampleProjectWizard_ProjectPage_Title);
        this.mainPage.setDescription(Messages.NewSampleProjectWizard_ProjectPage_Description);
        this.addPage((IWizardPage)this.mainPage);
        String name = this.sample.getName();
        if (name != null) {
            this.mainPage.setInitialProjectName(name);
        }
        if (!ArrayUtil.isEmpty((Object[])(extraPages = (projectWizardContributionManager = ProjectsPlugin.getDefault().getProjectWizardContributionManager()).createPages(null, this.sample.getNatures())))) {
            Object[] objectArray = extraPages;
            int n = extraPages.length;
            int n2 = 0;
            while (n2 < n) {
                Object page = objectArray[n2];
                this.addPage((IWizardPage)page);
                ++n2;
            }
        }
        projectWizardContributionManager.finalizeWizardPages(this.getPages(), this.sample.getNatures());
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        this.updatePerspective();
        this.selectAndReveal((IResource)this.newProject);
        this.openIndexFile();
        return true;
    }

    IProject getCreatedProject() {
        return this.newProject;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.NewSampleProjectWizard_Title);
    }

    protected void updatePerspective() {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
    }

    private void initDialogSettings() {
        IDialogSettings workbenchSettings = SamplesUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(NEWPROJECT_WIZARD);
        if (section == null) {
            section = workbenchSettings.addNewSection(NEWPROJECT_WIZARD);
        }
        this.setDialogSettings(section);
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject newProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IProjectDescription description = ResourceUtil.getProjectDescription((IPath)this.mainPage.getLocationPath(), (String[])this.sample.getNatures(), (String[])ArrayUtil.NO_STRINGS);
        description.setName(newProjectHandle.getName());
        description.setLocationURI(location);
        try {
            if (this.sample.isRemote()) {
                this.cloneFromGit(this.sample.getLocation(), newProjectHandle, description);
            } else {
                ProjectData projectData = this.mainPage.getProjectData();
                projectData.project = newProjectHandle;
                projectData.directory = this.mainPage.getLocationURI().getRawPath();
                projectData.appURL = "http://";
                this.doBasicCreateProject(newProjectHandle, description, this.sample, projectData);
                this.doPostProjectCreation(newProjectHandle);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (Throwable)e);
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    private void doBasicCreateProject(final IProject project, final IProjectDescription description, final IProjectSample sample, final ProjectData projectData) throws CoreException {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    CreateProjectOperation op = new CreateProjectOperation(description, Messages.NewSampleProjectWizard_CreateOp_Title);
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)NewSampleProjectWizard.this.getShell()));
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            IStatus status = sample.createNewProject(project, projectData, monitor);
                            if (status != null && !status.isOK()) {
                                IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)status.getMessage(), (Throwable)status.getException());
                            }
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(runnable, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.samples.ui", e.getMessage(), (Throwable)e));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExecutionException && t.getCause() instanceof CoreException) {
                CoreException cause = (CoreException)t.getCause();
                StatusAdapter status = cause.getStatus().getCode() == 275 ? new StatusAdapter((IStatus)new Status(2, "com.aptana.samples.ui", MessageFormat.format(Messages.NewSampleProjectWizard_Warning_DirectoryExists, project.getName()), (Throwable)cause)) : new StatusAdapter((IStatus)new Status(cause.getStatus().getSeverity(), "com.aptana.samples.ui", Messages.NewSampleProjectWizard_CreationProblems, (Throwable)cause));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.NewSampleProjectWizard_CreationProblems);
                StatusManager.getManager().handle(status, 4);
            }
            StatusAdapter status = new StatusAdapter((IStatus)new Status(2, "com.aptana.samples.ui", 0, MessageFormat.format(Messages.NewSampleProjectWizard_InternalError, t.getMessage()), t));
            status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.NewSampleProjectWizard_CreationProblems);
            StatusManager.getManager().handle(status, 5);
        }
    }

    private void cloneFromGit(final String gitURL, final IProject projectHandle, final IProjectDescription projectDescription) {
        File directory;
        IPath path = this.mainPage.getLocationPath();
        if (this.mainPage.useDefaults()) {
            path = path.append(projectDescription.getName());
        }
        if ((directory = path.toFile()).exists()) {
            FileUtil.deleteRecursively((File)directory);
        }
        final IPath projectPath = path;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CloneJob job = new CloneJob(gitURL, projectPath.toOSString(), true, true);
                    IStatus status = job.run(monitor);
                    if (!status.isOK()) {
                        throw new InterruptedException(status.getMessage());
                    }
                    try {
                        projectHandle.setDescription(projectDescription, null);
                        projectHandle.refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (Throwable)e);
                    }
                    DisconnectHandler.disconnect((IProject)projectHandle, null);
                    File toDelete = new File(projectHandle.getLocation().toFile(), ".gitignore");
                    if (toDelete.exists()) {
                        toDelete.delete();
                    }
                    if ((toDelete = new File(projectHandle.getLocation().toFile(), ".git")).exists()) {
                        FileUtil.deleteRecursively((File)toDelete);
                    }
                    NewSampleProjectWizard.this.doPostProjectCreation(projectHandle);
                }
            });
        }
        catch (InvocationTargetException e) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (Throwable)e);
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (Throwable)e);
        }
    }

    private void doPostProjectCreation(IProject newProject) {
        ProjectWizardContributionManager projectWizardContributionManager;
        IStatus contributorStatus;
        ISampleProjectHandler projectHandler = this.sample.getProjectHandler();
        if (projectHandler != null) {
            ProjectData projectData = this.mainPage.getProjectData();
            projectData.projectName = newProject.getName();
            projectHandler.projectCreated(newProject, (Object)projectData);
        }
        if ((contributorStatus = (projectWizardContributionManager = ProjectsPlugin.getDefault().getProjectWizardContributionManager()).performProjectFinish(newProject, (IProgressMonitor)new NullProgressMonitor())) != null && contributorStatus.getSeverity() == 4) {
            UIUtils.showErrorMessage((String)Messages.NewSampleProjectWizard_ServicesError, (String)contributorStatus.getMessage());
        }
    }

    private void openIndexFile() {
        IWorkbenchPage page;
        IFile indexFile = this.newProject.getFile("index.html");
        if (indexFile.exists() && (page = UIUtils.getActivePage()) != null) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)indexFile);
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)Messages.NewSampleProjectWizard_ERR_OpenIndexFile, (Throwable)e);
            }
        }
    }
}

